<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Proveedor extends Model
{
    protected $table = 'proveedores';
    protected $primaryKey = 'id_proveedor';

    protected $fillable = [
        'id_proveedor', 'nombre', 'id_tipo_documento', 'numero_documento', 'direccion', 'telefono', 'email','estado'
    ];

    public function tipo_documento()
    {
        return $this->belongsTo('App\Models\TipoDocumento', 'id_tipo_documento');
    }
}
