<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleVentaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_venta', function (Blueprint $table) {
            $table->integer('id_detalle_venta')->autoIncrement();
            $table->integer('id_venta');
            $table->integer('id_producto');
            $table->decimal('cantidad', 15, 6);
            $table->decimal('precio_venta', 15, 6);
            $table->decimal('impuesto', 15, 6);
            $table->decimal('precio_venta_neto', 15, 6);
            $table->decimal('descuento', 9, 2);
            $table->decimal('precio_venta_total', 9, 2);
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            
            $table->foreign('id_venta')
                  ->references('id_venta')->on('ventas')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_producto')->references('id_producto')->on('productos');      
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_venta');
    }
}
