<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_local == 0) {
		$consulta = 'SELECT * FROM delivery WHERE (created_at >= "'.$fecha1.' 00:00:00" AND created_at <= "'.$fecha2.' 23:59:59") AND estado= 1 ORDER BY id_delivery';
	} else{

		$consulta = 'SELECT * FROM delivery WHERE (created_at >= "'.$fecha1.' 00:00:00" AND created_at <= "'.$fecha2.' 23:59:59") AND estado= 1 AND id_local="'.$id_local.'"   ORDER BY id_delivery';
	}

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte Seven")
									 ->setSubject("Reporte Seven")
									 ->setDescription("Reporte Seven")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:J1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PEDIDOS POR DELIVERY REALIZADOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'CLIENTE')
		            ->setCellValue('C2', 'RUC / DNI')
		            ->setCellValue('D2', 'DIRECCION')

		            ->setCellValue('E2', 'TELEFONO')
					->setCellValue('F2', 'CORREO ELECTRONICO')


					->setCellValue('G2', 'NUMERO DE DELIVERY')
					->setCellValue('H2', 'FECHA EMISION')
					->setCellValue('I2', 'TOTAL S/') 

					->setCellValue('J2', 'TIPO DE PAGO')
					->setCellValue('K2', 'ESTADO DEL ENVIO')
					->setCellValue('L2', 'OBSERVACIONES');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:L2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(80);	

		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);

        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(100);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['numero_documento'])
			    ->setCellValue('D'.$i,  utf8_encode($fila['direccion']))

			    ->setCellValue('E'.$i, $fila['telefono'])
			    ->setCellValue('F'.$i,  utf8_encode($fila['email']))

			    ->setCellValue('G'.$i, "PEDIDO N° ".$fila['id_delivery'])
			    ->setCellValue('H'.$i, $fila['fecha_emision'])
			    ->setCellValue('I'.$i, $fila['total'])

			    ->setCellValue('J'.$i, $fila['metodo_pago'])
			    ->setCellValue('K'.$i, utf8_encode($fila['estado_delivery']))
			    ->setCellValue('L'.$i, utf8_encode($fila['observacion']));
			$i++;
			$j++;
			$suma = $suma+$fila['total'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('H'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('I'.$i)->getFont()->setBold(true);

		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "L".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_delivery.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






