$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
        keyboardShortcuts: false,
    	fields: {

            punto_partida: {
                rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'maxLength[100]', prompt : 'La direccion es muy larga'}
                ]
            },
            punto_llegada: {
                rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'maxLength[100]', prompt : 'La direccion es muy larga'}
                ]
            },
            nombre_transportista: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            documento_transportista: {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                ]
            },
            licencia: {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                ]
            },
            marca_placa: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            fecha_traslado: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            motivo: {
                rules: [{ type : 'empty', prompt : 'Seleccione una opcion'}]
            },
            peso: {
                optional: true,
                rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un peso valido'},
                ]
            },

    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {
  		
  		if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show');  
		} else {
			$('#frmNuevo').form('validate form');
		}

  	});	

	function sendForm() {

	    var data = $('#frmNuevo').serialize();
	 	
        $.requestApi('/guia/registrar', data, 'POST', function (resolve) {
	        if (resolve) { 
                $.showMessagesImprimir(resolve, APP_URL+"/guia/detalles/"+resolve.id_guia_remision, APP_URL+"/../pdf/imprimeGuia.php?id_guia="+resolve.id_guia_remision);
	        }
	    });
  
        return false;
	};

    /******************************************************************************/
    /* Consultar RUC  SUNAT clic enter
    /******************************************************************************/

    $('body').on('click', '#nombre_transportista', function(){
        $(this).attr("readonly", false);
    });

    $('#documento_transportista').on('keyup', function(){
        $(this).val($(this).val().trim());
    });

    $('#documento_transportista').on('keypress', function(e){
        if (e.keyCode == 13){
            var num = $('#documento_transportista').val();
            buscarDocumentoTransportista(num);
        }   
    });

    $('#loading_doc').on('click', function() {
        var num = $('#documento_transportista').val();
        buscarDocumentoTransportista(num);
    });

    function buscarDocumentoTransportista(num) 
    {   
        if ( num.length == 11  ) // FACTURA
        {
            $("#loading_doc").addClass('loading');
            $._requestApi('/cliente/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
                if (resolve.nombre) {
                    $('#nombre_transportista').val(resolve.nombre);
                }
                else {
                    $('#nombre_transportista').val('');
                }
                $("#loading_doc").removeClass('loading');
            }, function () {
                $("#loading_doc").removeClass('loading');
            });
        }

    }

    /*********************************************************************************************************/
    /* modal mostrar todos los clientes
    /*********************************************************************************************************/

    function buscarNombreCliente(cliente) {
  
        $._requestApi('/guia/getByNombre', {'search' : cliente }, 'GET', function (resolve) {
            if (resolve) {
                var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderClientes(resolve[i]));
                    }
                }
                $('#tbody_clientes').html(datos.join(''));
            }
            $("#btn_buscar_cli").removeClass('loading');
        });
    };

    $('.btn_buscar_cliente').on('click', function() {
        $('#buscar_cliente_modal').modal('show'); 
        $('#buscar_cliente').val('');
        //resetearTablaProducto();
    }); 


    $('#buscar_cliente').on('keypress', function(e){
        if (e.keyCode == 13){
            $("#btn_buscar_cli").addClass('loading');
            var cliente = $('#buscar_cliente').val();
            buscarNombreCliente(cliente);
        }   
    });

    $('#btn_buscar_cli').on('click', function() {
        $("#btn_buscar_cli").addClass('loading');
        var cliente = $('#buscar_cliente').val();
        buscarNombreCliente(cliente);
    });


    $('body').on('click', '.btn_seleccionar_cliente', function(){ 
        $("#nombre_transportista").val($(this).data("nombre"));
        $("#documento_transportista").val($(this).data("documento"));
        $("#licencia").val($(this).data("dni"));
        $("#marca_placa").val($(this).data("placa"));
        $('#buscar_cliente_modal').modal('hide'); 
    });

});

/*********************************************************************************************************/
/* funciones de busqueda de productos
/*********************************************************************************************************/

function renderClientes(resolve){
    var arr = [];
    arr = [
        '<tr>',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.nombre_transportista,'</td>',
            '<td>',resolve.documento_transportista,'</td>',
            '<td>',resolve.licencia,'</td>',
            '<td>',resolve.marca_placa,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_cliente" title="Seleccionar este cliente" data-nombre="',resolve.nombre_transportista,'" data-documento="',resolve.documento_transportista,'" data-dni="',resolve.licencia,'" data-placa="',resolve.marca_placa,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}