@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">SELECCIONE UN COMPROBANTE PARA DAR DE BAJA</h4>
           
             <div class="ui equal width grid">
                <div class="row">
                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="tipo_comprobante">
                            <option value="">Seleccione</option>
                            <option value="1">FACTURAS</option>
                            <option value="3">NOTAS DE CREDITO</option>
                            <option value="4">NOTAS DE DEBITO</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Tipo</th>
                        <th class="head_table">Comprobante</th>
                        <th class="head_table">Fecha de Emision</th>
                        <th class="head_table">Sucursal</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>

                @if($tipo == 1 || $tipo == 2)
                    <tbody>
                       <?php /**/ $i = $data->firstItem() /**/ ?>
                        @foreach ($data as $comprobante)
                        <tr>
                            <td>{{ $i }}</td>
                            <td>{{ $comprobante->tipo_comprobante->nombre }}</td>
                            <td>{{ $comprobante->nombre_comprobante }}</td>
                            <td>{{ $comprobante->fecha_venta }}</td>
                            <td>{{ $comprobante->local->nombre }}</td>
                            <td>    
                                <?php /**/ $count = 0/**/ ?>
                                @foreach($bajas as $baja)
                                    @if( $comprobante->id_venta == $baja->id_venta)
                                        <?php /**/ $count++ /**/ ?>
                                        <?php /**/ $id_baja = $baja->id_baja/**/ ?>
                                    @endif
                                @endforeach 

                                @if($count > 0)
                                    <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('baja/detalles/'.$id_baja ) }}">
                                        <div class="hidden content">Emitido</div>
                                        <div class="visible content"><i class="search icon"></i></div>
                                    </a>
                                @else
                                    <a class="ui mini vertical animated green button" title="Dar baja este registro" href="{{ url('baja/nuevo/'.$comprobante->id_venta.'/'.$comprobante->id_tipo_comprobante ) }}">
                                        <div class="hidden content">Emitir</div>
                                        <div class="visible content"><i class="check icon"></i></div>
                                    </a>
                                @endif                      
                            </td>
                        </tr>
                        <?php /**/ $i++ /**/ ?>
                        @endforeach
                    </tbody>
                @endif
                @if( $tipo == 3 || $tipo == 4 )
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $comprobante)
                    @if($comprobante->venta->id_tipo_comprobante != 2)
                        <tr>
                            <td>{{ $i }}</td>
                            <td>{{ $comprobante->tipo_comprobante->nombre }}</td>
                            <td>{{ $comprobante->nombre_nota }}</td>
                            <td>{{ $comprobante->fecha_emision }}</td>
                            <td>{{ $comprobante->local->nombre }}</td>
                            <td>    
                                <?php /**/ $count = 0/**/ ?>
                                @foreach($bajas as $baja)
                                    @if( $comprobante->id_nota == $baja->id_nota)
                                        <?php /**/ $count++ /**/ ?>
                                        <?php /**/ $id_baja = $baja->id_baja/**/ ?>
                                    @endif
                                @endforeach 

                                 @if($count > 0)
                                    <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('baja/detalles/'.$id_baja ) }}">
                                        <div class="hidden content">Emitido</div>
                                        <div class="visible content"><i class="search icon"></i></div>
                                    </a>
                                @else
                                    <a class="ui mini vertical animated green button" title="Dar baja este registro" href="{{ url('baja/nuevo/'.$comprobante->id_nota.'/'.$comprobante->id_tipo_comprobante ) }}">
                                        <div class="hidden content">Emitir</div>
                                        <div class="visible content"><i class="check icon"></i></div>
                                    </a>
                                @endif                      
                            </td>
                        </tr>
                    @endif    
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                @endif
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop


@section('scripts')
    <script src="{{ asset('js/baja/emitir.js') }}"></script>
@stop


