@extends('layout.main')
@section('content')
@if ($data)

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DEL DELIVERY - PEDIDO N° {{ $data->id_delivery }}</h4>
            <input type="hidden" id="id_delivery" value="{{$data->id_delivery}}">

            <div class="ui success message">
                <div class="ui equal width grid">


                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->nombre }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">DNI / RUC de Cliente :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->numero_documento }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Email :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->email }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Telefono :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->telefono }}</div>
                    </div>
                    
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Direccion de Cliente :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ ucwords(mb_strtolower($data->direccion)) }}</div>
                        @if ($data->latitud !=null && $data->longitud !=null)
                        <input type="hidden" id="latitud" value="{{$data->latitud}}">
                        <input type="hidden" id="longitud" value="{{$data->longitud}}">
                        <input type="hidden" id="direccion" value="{{ucwords(mb_strtolower($data->direccion))}}">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Ubicacion :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="#" class="btn_modal_mapa">VER MAPA</a></div>
                        @endif
                    </div>


                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  four wide computer column message_header">Observacion :</div>
                        <div class="sixteen wide mobile eight wide tablet  four wide computer column">{{ $data->observacion!=null ? ucwords(mb_strtolower($data->observacion)) : 'Ninguna observacion' }}</div>
                    </div>
                </div> 
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Emision :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_emision }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->total }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Metodo de Pago :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->metodo_pago }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Estado del Pedido :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column" style="color: red !important">{{ $data->estado_delivery }}</div>
                    </div>
                </div>
            </div> 

            @if($data->estado_delivery != 'PENDIENTE')
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">{{ $data->estado_delivery }} POR :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->usuario->username }}</div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">{{ $data->estado_delivery }} EL :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->updated_at }}</div>
                    </div>
                </div>
            </div>
            @endif

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned" data-tooltip="Monto de Descuento" data-position="top center" data-inverted="">Dscto S/</th>
                        <th class="center aligned">Subtotal</th>
                        <th class="center aligned">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($detalle_proforma as $venta)
                    <tr data-table="{{ $venta->id_detalle_delivery }}">
                        <td><a href="{{ url('producto/editar/'.$venta->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($venta->producto->nombre)) }} {{ $venta->producto->descripcion }}</a></td>
                        <td>{{ $venta->producto->unidad_medida->nombre }}</td>
                        <td>{{ $venta->cantidad }}</td>
                        <td>{{ $venta->precio }}</td>
                        <td>{{ $venta->descuento==0 ? $venta->descuento : '-'.$venta->descuento  }}</td>
                        <td class="warning">{{ $venta->subtotal }}</td>
                        <td>

                            @if ($loop->count > 1)

                                <div class="ui mini vertical animated red button button_delete_modal" title="Eliminar registro" data-id="{{ $venta->id_detalle_delivery }}">
                                <div class="hidden content">Eliminar</div>
                                <div class="visible content"><i class="trash alternate icon"></i></div>
                                </div>
                                
                            @endif
                            
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                &nbsp;&nbsp;<a href="#" class="btn_modal_producto">(+) Agregar </a>

                @if ($data->estado_delivery == 'PENDIENTE')
                <div class="ui small right floated red button btn_anular"><i class="times icon"></i>Cancelar</div>
                <div class="ui small right floated orange button btn_entregar"><i class="check icon"></i>Atendido</div>
                @endif
                
                <div class="ui small right floated primary button btn_imprimir" data-id="{{ $data->id_delivery }}"><i class="print icon"></i>Ticket</div>
                <div class="ui small right floated green button btn_imprimir_a4" data-id="{{ $data->id_delivery }}"><i class="print icon"></i>A4</div> 
                <a class="ui small right floated violet button" href="{{ url('venta/delivery_venta/'.$data->id_delivery) }}"><i class=" sign dollar icon"></i>Emitir Comprobante</a> 
                
                {{-- <div class="ui small right floated green button btn_enviar"><i class="paper plane icon"></i>Enviar Correo</div> --}}
            </div>  

        </div>
    </div>


    <!--start update modal -->
    <div class="ui small basic modal" id="update_modal">
        <div class="ui icon header"><i class="paper plane icon"></i>Cancelar pedido</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere anular el pedido?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para anular compra"> <i class="checkmark icon"></i>Anular</div>
        </div>
    </div>
    <!--end update modal -->

    <!--start update modal -->
    <div class="ui small basic modal" id="entregar_modal">
        <div class="ui icon header"><i class="paper plane icon"></i>Entregar pedido</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿EL pedido delivery ya fue atendido?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>No</div>
            <div class="ui green ok inverted button" title="Haga clic marcar como entregado el pedido"> <i class="checkmark icon"></i>Si</div>
        </div>
    </div>
    <!--end update modal -->

    <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_producto_modal">
        <div class="header">Agregar Productos</div>
        <div class="scrolling content" style="height: 250px;">

            <form class="ui form" id="frmAgregar" autocomplete="off"> 
                <input type="hidden" name="id_delivery" value="{{$data->id_delivery}}">
                <div class="two fields">
                    <div class="three wide field">
                        <label>Buscar Producto : </label>
                    </div>
                    <div class="ten wide field">
                        <select class="ui search selection" name="id_prod">
                        </select>  
                    </div>
                </div> 
            
                <table class="ui celled table">
                    <thead>
                        <tr>
                            <th class="center aligned">Producto</th>
                            <th class="center aligned" data-tooltip="Cantidad a vender" data-position="top center" data-inverted="">Cantidad</th>
                            <th class="center aligned" data-tooltip="Precio de venta unitario" data-position="top center" data-inverted="">Precio S/</th>
                            <th class="center aligned" data-tooltip="Monto para descuento" data-position="top center" data-inverted="">Dscto S/</th>
                            <th class="center aligned">Subtotal S/</th>
                            <th class="center aligned">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                </table>
            </form>

        </div>
        <div class="actions" >
            <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <a href="#" class="ui left floated  btn_nuevo_producto" style="float: left; margin-top: 10px">(+) Crear Nuevo</a>
            <div class="ui labeled small input">
                <label class="ui brown label">TOTAL  S/</label>
                <input type="text" name="total_venta" id="total_venta" size="5" readonly style="width: 0%">
            </div> 
            <div class="ui right floated primary button btn_agregar"><i class="plus icon"></i>AGREGAR</div>
        </div>
    </div>
    <!--end buscar producto modal -->

    <!--start nuevo producto modal -->
    <div class="ui modal" id="nuevo_producto_modal">
        <div class="header">Registrar Nuevo </div>     
        <div class="content">
            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNuevoProducto" autocomplete="off">
                
                <input type="hidden" name="situacion_impuesto" value="AFECTO">
                <input type="hidden" name="tipo_impuesto" value="IGV">
                <input type="hidden" name="valor_impuesto" value="{{$empresa->valor_impuesto}}">
                <input type="hidden" name="tipo_producto" value="Generico">
                <input type="hidden" name="id_unidad_medida" value="1">
                <input type="hidden" name="id_tipo_presentacion" value="1">
                <input type="hidden" name="codigo_barras" value="">
                <input type="hidden" name="cantidad" value="1">

               
                <div class="two fields">
                    <div class="twelve wide field">
                        <label>Nombre del Concepto</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="800" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="four wide field">
                        <label>Monto</label>
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="precio" maxlength="11">
                        </div>  
                    </div>
                </div>  

            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_producto"><i class="plus icon"></i>AGREGAR</div>
        </div>
    </div>
    <!--end nuevo producto  modal --> 

    <!--start register modal -->
    <div class="ui small basic modal" id="agregar_modal">
        <div class="ui icon header"><i class="circular inverted white dollar plus icon"></i>Agregar</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea agregar estos productos?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para agregar"> <i class="paper plane icon"></i>Agregar</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->

    <!--start buscar MAPA modal -->
    <div class="ui standard large modal" id="mapa_modal">
        <div class="header">Ubicacion del Cliente</div>
        <div class="scrolling content" style="height: 500px;">

        <div id="map" ><!-- carga api google maps --></div>

        </div>
        <div class="actions" >
            <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar MAPA modal -->

@else
    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            <h3 class="ui header black centered">No se puede realizar esta accion</h3>
        </div>
    </div>    
@endif

@stop

@section('scripts')
   <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCEe4jiCxBqOF-mjTVYjxejdTEjWCev8I0&language=es&region=PE"></script> 
    <script src="{{ asset('js/delivery/detalles.js') }}"></script>
    <script type="text/javascript">
        google.maps.event.addDomListener(window, 'load', load_map);
    </script>
@stop


