@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DATOS DE MI EMPRESA</h4>
            <br>

            <form class="ui form" id="frmEditar" autocomplete="off" files="true" enctype="multipart/form-data">
                <input type="hidden" id="id_empresa" name="id_empresa" value="{{ $data->id_empresa }}">
                <div class="field">
                    <div class="field">
                        <label>Razon Social</label>
                        <div class="ui small input ">
                          <input type="text" name="razon_social" maxlength="200" oninput="$.upperCase(this)" value="{{ $data->razon_social}}">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>RUC</label>
                        <div class="ui small input ">
                          <input type="text" name="ruc" maxlength="11" value="{{ $data->ruc }}">
                        </div>
                    </div>
                    <div class="field">
                        <label>N° Autorizacion SUNAT</label>
                        <div class="ui small input ">
                          <input type="text" name="autorizacion" maxlength="50" oninput="$.upperCase(this)" value="{{ $data->autorizacion }}">
                        </div>
                    </div>
                </div>
                
                <div class="two fields">
                    <div class="field">
                        <label>Representante Legal</label>
                        <div class="ui small input ">
                          <input type="text" name="representante" maxlength="100" oninput="$.upperCase(this)" value="{{ $data->representante }}">
                        </div>
                    </div>
                    <div class="field">
                        <label>DNI de representante</label>
                        <div class="ui small input ">
                          <input type="text" name="dni" maxlength="8" value="{{ $data->dni }}">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Telefono de la empresa</label>
                        <div class="ui small input ">
                          <input type="text" name="telefono"  maxlength="30" value="{{ $data->telefono }}">
                        </div>
                    </div>
                    <div class="field">
                        <label>Direccion de la empresa</label>
                        <div class="ui small input ">
                          <input type="text" name="direccion" maxlength="200" oninput="$.upperCase(this)" value="{{ $data->direccion }}">
                        </div>
                    </div>
                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Pagina Web</label>
                        <div class="ui small input ">
                          <input type="text" name="pagina_web" maxlength="50" value="{{ $data->pagina_web }}">
                        </div>
                    </div>
                    <div class="field">
                        <label>Email de la empresa</label>
                        <div class="ui small input ">
                          <input type="text" name="email" maxlength="50" value="{{ $data->email }}">
                        </div>
                    </div>
                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Ubigeo</label>
                        <div class="ui small input ">
                          <input type="text" name="ubigeo" maxlength="50" value="{{ $data->ubigeo }}">
                        </div>
                    </div>
                   
                    <div class="field">
                        <label>Valor del Impuesto</label>
                        <div class="ui right labeled small input">
                            <input type="text" name="valor_impuesto" id="valor_impuesto" value="{{$data->valor_impuesto}}" maxlength="8">
                            <label class="ui label">%</label>
                        </div>  
                    </div>
                </div> 

                <div class="two fields">

                    <div class="field">
                        <label>Valor del ICBPER</label>
                        <div class="ui left labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="valor_icbper" id="valor_icbper" value="{{$data->valor_icbper}}" maxlength="8" placeholder="0.50">
                            
                        </div>  
                    </div>


                    <div class="field">
                        <label>Habilitar puntos de los clientes?</label>
                        <select class="ui small input dropdown" name="modulo_puntos">
                                @if($data->modulo_puntos == 0)
                                    <option value="0" selected>NO</option>
                                    <option value="1">SI</option>
                                @else
                                    <option value="1" selected>SI</option>
                                    <option value="0">NO</option>
                                @endif
                        </select>  
                    </div>

                </div> 


                <div class="form_footer">
                    <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                </div>    
            </form>

        </div>
    </div>

    <!--start update modal -->
    <div class="ui small basic modal" id="update_modal">
        <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
        </div>
    </div>
    <!--end update modal -->
    
@stop

@section('scripts')
    <script src="{{ asset('js/empresa/editar.js') }}"></script>
@stop


