<!DOCTYPE html>
<html lang="ES-es">
	<head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta http-equiv="cache-control" content="no-cache"/>
		<meta http-equiv="expires" content="0"/>
		<meta http-equiv="pragma" content="no-cache"/>
		<title>Iniciar Sesión | Seven</title>
		<meta name="description" content="Sistema de Ventas, Almacén y Facturación Electronica - Seven">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
		<link rel="shortcut icon" href="{{ asset('ico/favicon.ico') }}" type="image/x-icon">
		<link rel="stylesheet" href="{{ asset('css/semantic.css') }}">
		<link rel="stylesheet" href="{{ asset('css/login.css') }}">
	</head>
	<body cz-shortcut-listen="true">
		<!-- Start Login Page -->
		<section id="wrap">
			<div class="container">
				<span><img src="{{ asset('img/isologo.png') }}" alt="Seven"/></span>
				<h1>Seven</h1>
				<hr class="slideRight">
				<p>Sistema de ventas y facturación electrónica</p>
			</div>
			<div class="ui hidden divider"></div>	
			<div class="ui middle aligned center aligned grid">
			  <div class="column">
			    <form class="ui form" method="POST" action="{{ route('loginme') }}" autocomplete="off">
			      <div class="ui piled segment">
			      	{{  csrf_field() }}
			        <div class="field {{ $errors->has('username') ? 'error' : '' }}">
			          <div class="ui large left icon input">
			            <i class="user icon"></i>
			            <input type="text" name="username" placeholder="Usuario"  value="{{ old('username') }}" maxlength="20" required>
			          </div>
			        </div>
			        <div class="field {{ $errors->has('password') ? 'error' : '' }}">
			          <div class="ui large left icon  input">
			            <i class="lock icon"></i>
			            <input type="password" name="password" placeholder="Contraseña" value="{{ old('password') }}"  maxlength="50" required>
			          </div>
			        </div>
			        <div class="field">
			          	<select class="ui input dropdown" name="id_local">
			          		@foreach($data as $local)
                               <option value="{{ $local->id_local }}">{{ ucwords(mb_strtolower($local->nombre))}} ({{$local->tipo_local->nombre}})</option>
                            @endforeach
			          	</select>
			        </div>
			        <button class="fluid ui primary button large " id="btn_login" type="submit">
			        	<i class="paper plane icon"></i> INGRESAR
			        </button>
			        <br>
					    <a href="{{ route('recovery') }}">Olvidé mi contraseña</a>
			      </div>
			    </form>
			   	
			   	@if ($errors->any())
				    <div class="ui error message" style="text-align: left;">
						<ul>
							@foreach ($errors->all() as $error)
						    	<li>{{ $error }}</li>
						    @endforeach
						</ul>    	
				    </div>
			    @endif
				@if (Session::has('flash_error'))
				    <div class="ui error message">
						<i class="exclamation triangle icon"></i>{{ Session::get('flash_error') }}
				    </div>
			    @endif
			  </div>
			</div>


			<footer>
				<div id="copy">© Seven &nbsp;|&nbsp; <?php echo date("Y"); ?></div>
			</footer>
		</section>
		<!-- End Login Page -->

		<script src="{{ asset('js/jquery-3.3.1.min.js') }}"></script>
		<script src="{{ asset('js/semantic.min.js') }}"></script>
		<script type="text/javascript">
			$('.ui.dropdown').dropdown();
		</script>

	</body>
</html>