-- phpMyAdmin SQL Dump
-- version 4.8.0
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 29-01-2022 a las 22:46:26
-- Versión del servidor: 10.1.31-MariaDB
-- Versión de PHP: 7.2.4

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `seven`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `bajas`
--

CREATE TABLE `bajas` (
  `id_baja` int(11) NOT NULL,
  `id_usuario` int(11) DEFAULT NULL,
  `id_local` int(11) DEFAULT NULL,
  `id_venta` int(11) DEFAULT NULL,
  `id_nota` int(11) DEFAULT NULL,
  `id_tipo_comprobante` int(11) DEFAULT NULL,
  `nombre_baja` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_emision` date DEFAULT NULL,
  `fecha_referencia` date DEFAULT NULL,
  `serie` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero` int(11) DEFAULT NULL,
  `motivo` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_envio` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mensaje_envio` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `clientes`
--

CREATE TABLE `clientes` (
  `id_cliente` int(11) NOT NULL,
  `id_tipo_documento` int(11) DEFAULT NULL,
  `nombre` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_documento` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `puntos` decimal(9,2) NOT NULL DEFAULT '0.00',
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `clientes`
--

INSERT INTO `clientes` (`id_cliente`, `id_tipo_documento`, `nombre`, `numero_documento`, `direccion`, `email`, `telefono`, `puntos`, `estado`, `created_at`, `updated_at`) VALUES
(1, 2, 'CLIENTES VARIOS', '00000001', '', NULL, NULL, '0.00', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `compras`
--

CREATE TABLE `compras` (
  `id_compra` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `id_proveedor` int(11) DEFAULT NULL,
  `tipo_comprobante` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_comprobante` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_compra` date DEFAULT NULL,
  `tipo_compra` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_pago` date DEFAULT NULL,
  `total_compra` decimal(9,2) NOT NULL,
  `observacion` varchar(800) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `delivery`
--

CREATE TABLE `delivery` (
  `id_delivery` int(11) NOT NULL,
  `id_usuario` int(11) DEFAULT NULL,
  `id_local` int(11) DEFAULT NULL,
  `nombre` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_documento` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitud` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitud` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_emision` date DEFAULT NULL,
  `total` decimal(9,2) DEFAULT NULL,
  `metodo_pago` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_pago` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observacion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_delivery` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDIENTE',
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_compra`
--

CREATE TABLE `detalle_compra` (
  `id_detalle_compra` int(11) NOT NULL,
  `id_compra` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `cantidad` decimal(9,2) NOT NULL,
  `precio_compra_unitario` decimal(9,2) NOT NULL,
  `precio_compra_total` decimal(9,2) NOT NULL,
  `precio_venta_unitario` decimal(9,2) NOT NULL,
  `utilidad` decimal(9,2) NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_credito`
--

CREATE TABLE `detalle_credito` (
  `id_detalle_credito` int(11) NOT NULL,
  `id_usuario` int(11) DEFAULT NULL,
  `id_venta` int(11) DEFAULT NULL,
  `id_proforma` int(11) DEFAULT NULL,
  `fecha_pago` date DEFAULT NULL,
  `monto` decimal(9,2) DEFAULT NULL,
  `observacion` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_delivery`
--

CREATE TABLE `detalle_delivery` (
  `id_detalle_delivery` int(11) NOT NULL,
  `id_delivery` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `cantidad` decimal(15,6) NOT NULL,
  `precio` decimal(15,6) NOT NULL,
  `descuento` decimal(9,2) NOT NULL,
  `subtotal` decimal(9,2) NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_guia_remision`
--

CREATE TABLE `detalle_guia_remision` (
  `id_detalle_guia_remision` int(11) NOT NULL,
  `id_guia_remision` int(11) DEFAULT NULL,
  `id_producto` int(11) DEFAULT NULL,
  `cantidad` decimal(9,2) DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_proforma`
--

CREATE TABLE `detalle_proforma` (
  `id_detalle_proforma` int(11) NOT NULL,
  `id_proforma` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `cantidad` decimal(15,6) NOT NULL,
  `precio` decimal(15,6) NOT NULL,
  `descuento` decimal(9,2) NOT NULL,
  `subtotal` decimal(9,2) NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_resumen`
--

CREATE TABLE `detalle_resumen` (
  `id_detalle_resumen` int(11) NOT NULL,
  `id_resumen` int(11) NOT NULL,
  `id_venta` int(11) DEFAULT NULL,
  `id_nota` int(11) DEFAULT NULL,
  `nombre_comprobante` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtotal` decimal(9,2) DEFAULT NULL,
  `impuesto` decimal(9,2) DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_traslado`
--

CREATE TABLE `detalle_traslado` (
  `id_detalle_traslado` int(11) NOT NULL,
  `id_traslado` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `cantidad` decimal(9,2) DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_venta`
--

CREATE TABLE `detalle_venta` (
  `id_detalle_venta` int(11) NOT NULL,
  `id_venta` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `cantidad` decimal(15,6) NOT NULL,
  `precio_venta` decimal(15,6) NOT NULL,
  `impuesto` decimal(15,6) NOT NULL,
  `precio_venta_neto` decimal(15,6) NOT NULL,
  `descuento` decimal(9,2) NOT NULL,
  `precio_venta_total` decimal(9,2) NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `egresos`
--

CREATE TABLE `egresos` (
  `id_egreso` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `tipo_egreso` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descripcion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_comprobante` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_comprobante` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monto` decimal(9,2) DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `empresa`
--

CREATE TABLE `empresa` (
  `id_empresa` int(11) NOT NULL,
  `razon_social` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruc` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `representante` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dni` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `autorizacion` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pagina_web` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ubigeo` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor_impuesto` decimal(9,2) DEFAULT NULL,
  `valor_icbper` decimal(9,2) DEFAULT NULL,
  `modulo_puntos` tinyint(4) NOT NULL DEFAULT '0',
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `empresa`
--

INSERT INTO `empresa` (`id_empresa`, `razon_social`, `ruc`, `representante`, `dni`, `autorizacion`, `direccion`, `telefono`, `pagina_web`, `email`, `ubigeo`, `valor_impuesto`, `valor_icbper`, `modulo_puntos`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'NOMBRE DE MI EMPRESA INDIVIDUAL DE RESPONSABILIDAD LIMITADA E.I.R.L.', '12345678910', 'JUAN PEREZ', '12345678', 'SUNAT', 'AV. DIRECCION N° 123 ABANCAY - APURIMAC', '083 323232', 'www.soft.pe', 'hola@seven.com', '030101', '18.00', '0.40', 0, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `guia_remision`
--

CREATE TABLE `guia_remision` (
  `id_guia_remision` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `id_venta` int(11) DEFAULT NULL,
  `id_cliente` int(11) DEFAULT NULL,
  `id_tipo_comprobante` int(11) DEFAULT NULL,
  `serie_guia` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_guia` int(11) DEFAULT NULL,
  `nombre_guia` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_emision` date DEFAULT NULL,
  `fecha_traslado` date DEFAULT NULL,
  `motivo` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `punto_partida` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `punto_llegada` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nombre_transportista` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `documento_transportista` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `licencia` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marca_placa` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `peso` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observacion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_envio` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mensaje_envio` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `local`
--

CREATE TABLE `local` (
  `id_local` int(11) NOT NULL,
  `id_tipo_local` int(11) NOT NULL,
  `nombre` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serie_factura` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serie_boleta` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serie_guia` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `local`
--

INSERT INTO `local` (`id_local`, `id_tipo_local`, `nombre`, `direccion`, `telefono`, `serie_factura`, `serie_boleta`, `serie_guia`, `estado`, `created_at`, `updated_at`) VALUES
(1, 1, 'TIENDA PRINCIPAL', 'AV. DIRECCION N° 123 ABANCAY - APURIMAC', '083-323232', 'FF01', 'BB01', 'TT01', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2018_05_19_095918_create_tipo_local_table', 1),
(2, '2018_05_19_095938_create_local_table', 1),
(3, '2018_05_19_100011_create_rol_table', 1),
(4, '2018_05_19_100103_create_usuarios_table', 1),
(5, '2018_06_04_193700_create_tipo_documento_table', 1),
(6, '2018_06_04_205751_create_proveedores_table', 1),
(7, '2018_06_05_122855_create_tipo_presentacion_table', 1),
(8, '2018_06_05_122915_create_unidad_medida_table', 1),
(9, '2018_06_05_144006_create_productos_table', 1),
(10, '2018_06_07_142211_create_compras_table', 1),
(11, '2018_06_10_160517_create_detalle_compra_table', 1),
(12, '2018_06_10_164208_create_producto_local_table', 1),
(13, '2018_06_12_170312_create_clientes_table', 1),
(14, '2018_06_12_170320_create_tipo_comprobante_table', 1),
(15, '2018_06_12_170345_create_ventas_table', 1),
(16, '2018_06_12_171352_create_detalle_venta_table', 1),
(17, '2018_06_25_084901_create_empresa_table', 1),
(18, '2018_07_11_123304_create_notas_table', 1),
(19, '2018_07_14_183647_create_resumenes_table', 1),
(20, '2018_07_14_184016_create_detalle_resumen_table', 1),
(21, '2018_07_22_133517_create_retiros_table', 1),
(22, '2018_07_22_174657_create_traslados_table', 1),
(23, '2018_07_22_174854_create_detalle_traslado_table', 1),
(24, '2018_07_22_212307_create_egresos_table', 1),
(25, '2018_08_31_215100_create_proformas_table', 1),
(26, '2018_08_31_215128_create_detalle_proforma_table', 1),
(27, '2018_09_02_114349_create_guia_remision_table', 1),
(28, '2018_11_17_094550_create_bajas_table', 1),
(29, '2019_02_04_120222_create_detalle_credito_table', 1),
(30, '2020_05_11_152356_create_delivery_table', 1),
(31, '2020_05_11_152424_create_detalle_delivery_table', 1),
(32, '2021_11_03_195119_create_ventas_credito_table', 1),
(33, '2021_12_08_095126_create_detalle_guia_remision_table', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `notas`
--

CREATE TABLE `notas` (
  `id_nota` int(11) NOT NULL,
  `id_venta` int(11) DEFAULT NULL,
  `id_usuario` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `id_tipo_comprobante` int(11) NOT NULL,
  `serie_nota` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_nota` int(11) NOT NULL,
  `nombre_nota` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_emision` date DEFAULT NULL,
  `id_motivo` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `motivo` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descripcion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contingencia` tinyint(4) NOT NULL DEFAULT '0',
  `estado_envio` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mensaje_envio` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `productos`
--

CREATE TABLE `productos` (
  `id_producto` int(11) NOT NULL,
  `id_tipo_presentacion` int(11) NOT NULL,
  `id_unidad_medida` int(11) NOT NULL,
  `nombre` varchar(800) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_barras` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `precio` decimal(9,2) DEFAULT NULL,
  `precio_mayorista` decimal(9,2) DEFAULT NULL,
  `precio_compra` decimal(9,2) DEFAULT NULL,
  `utilidad` decimal(9,2) DEFAULT NULL,
  `tipo_producto` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `lote` varchar(800) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `situacion_impuesto` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_impuesto` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor_impuesto` decimal(9,2) DEFAULT NULL,
  `icbper` tinyint(4) NOT NULL DEFAULT '0',
  `url_imagen` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `producto_local`
--

CREATE TABLE `producto_local` (
  `id_producto_local` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `stock` decimal(9,2) NOT NULL DEFAULT '1000050.00',
  `stock_alerta` int(11) NOT NULL DEFAULT '10',
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `proformas`
--

CREATE TABLE `proformas` (
  `id_proforma` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `nombre` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_documento` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_emision` date DEFAULT NULL,
  `total` decimal(9,2) DEFAULT NULL,
  `adelanto` decimal(9,2) DEFAULT NULL,
  `saldo` decimal(9,2) DEFAULT NULL,
  `tipo` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PROFORMA',
  `observacion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `genera_venta` tinyint(4) NOT NULL DEFAULT '0',
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `proveedores`
--

CREATE TABLE `proveedores` (
  `id_proveedor` int(11) NOT NULL,
  `nombre` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_tipo_documento` int(11) DEFAULT NULL,
  `numero_documento` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `resumenes`
--

CREATE TABLE `resumenes` (
  `id_resumen` int(11) NOT NULL,
  `id_local` int(11) DEFAULT NULL,
  `id_tipo_comprobante` int(11) DEFAULT NULL,
  `nombre_resumen` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_emision` date DEFAULT NULL,
  `fecha_referencia` date DEFAULT NULL,
  `estado_envio` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mensaje_envio` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `retiros`
--

CREATE TABLE `retiros` (
  `id_retiro` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `motivo_retiro` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cantidad_retiro` decimal(9,2) DEFAULT NULL,
  `monto_perdido` decimal(9,2) DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `rol`
--

CREATE TABLE `rol` (
  `id_rol` int(11) NOT NULL,
  `nombre` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `rol`
--

INSERT INTO `rol` (`id_rol`, `nombre`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Administrador', 1, NULL, NULL),
(2, 'Personal de Ventas', 1, NULL, NULL),
(3, 'Personal de Almacen', 1, NULL, NULL),
(4, 'Personal de Ventas y Almacen', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_comprobante`
--

CREATE TABLE `tipo_comprobante` (
  `id_tipo_comprobante` int(11) NOT NULL,
  `nombre` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grupo` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `tipo_comprobante`
--

INSERT INTO `tipo_comprobante` (`id_tipo_comprobante`, `nombre`, `codigo`, `grupo`) VALUES
(1, 'FACTURA', '01', 1),
(2, 'BOLETA', '03', 1),
(3, 'NOTA DE CREDITO', '07', 2),
(4, 'NOTA DE DEBITO', '08', 2),
(5, 'G.R. REMITENTE', '09', 3),
(6, 'G.R. TRANSPORTISTA', '31', 3);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_documento`
--

CREATE TABLE `tipo_documento` (
  `id_tipo_documento` int(11) NOT NULL,
  `nombre` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `tipo_documento`
--

INSERT INTO `tipo_documento` (`id_tipo_documento`, `nombre`, `codigo`) VALUES
(1, 'RUC', 6),
(2, 'DNI', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_local`
--

CREATE TABLE `tipo_local` (
  `id_tipo_local` int(11) NOT NULL,
  `nombre` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `tipo_local`
--

INSERT INTO `tipo_local` (`id_tipo_local`, `nombre`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Tienda', 1, NULL, NULL),
(2, 'Almacen', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_presentacion`
--

CREATE TABLE `tipo_presentacion` (
  `id_tipo_presentacion` int(11) NOT NULL,
  `nombre` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `tipo_presentacion`
--

INSERT INTO `tipo_presentacion` (`id_tipo_presentacion`, `nombre`) VALUES
(1, 'Indefinido'),
(2, 'Unidad'),
(3, 'Balde'),
(4, 'Botella'),
(5, 'Carton'),
(6, 'Bolsa'),
(7, 'Barril'),
(8, 'Caja'),
(9, 'Cilindro'),
(10, 'Lata'),
(11, 'Rollo'),
(12, 'Cajon'),
(13, 'Par'),
(14, 'Juego'),
(15, 'Tira'),
(16, 'Tanque'),
(17, 'Frasco'),
(18, 'Saco'),
(19, 'Paquete'),
(20, 'Pieza'),
(21, 'Estuche'),
(22, 'Vidrio'),
(23, 'Plastico'),
(24, 'Pliegue'),
(25, 'Lamina'),
(26, 'Conjunto'),
(27, 'Gel'),
(28, 'Gotas'),
(29, 'Tubo'),
(30, 'Cono'),
(31, 'Ciento de unidades'),
(32, 'Tambor'),
(33, 'Paleta'),
(34, 'Hoja'),
(35, 'Placa'),
(36, 'Pliego'),
(37, 'Resma'),
(38, 'Grueso'),
(39, 'Fardo'),
(40, 'Bobina'),
(41, 'Sobre'),
(42, 'Otros');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `traslados`
--

CREATE TABLE `traslados` (
  `id_traslado` int(11) NOT NULL,
  `id_local_origen` int(11) NOT NULL,
  `id_local_destino` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `descripcion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flete` decimal(9,2) DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `unidad_medida`
--

CREATE TABLE `unidad_medida` (
  `id_unidad_medida` int(11) NOT NULL,
  `nombre` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abreviatura` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `unidad_medida`
--

INSERT INTO `unidad_medida` (`id_unidad_medida`, `nombre`, `abreviatura`) VALUES
(1, 'Unidad', 'und'),
(2, 'Gramos', 'gr'),
(3, 'Miligramos', 'mg'),
(4, 'Kilogramos', 'kg'),
(5, 'Libras', 'lb'),
(6, 'Toneladas', 'ton'),
(7, 'Mililitros', 'ml'),
(8, 'Litros', 'ltr'),
(9, 'Galones', 'gal'),
(10, 'Onzas', 'oz'),
(11, 'Global', 'gbl'),
(12, 'Pies', 'pie'),
(13, 'Pies Cuadrados', 'pie2'),
(14, 'Pies Cubicos', 'pie3'),
(15, 'Pulgadas', 'pulg'),
(16, 'Pulgadas Cuadradas', 'pulg2'),
(17, 'Centimetros', 'cm'),
(18, 'Centimetros Cuadrados', 'cm2'),
(19, 'Centimetros Cubicos', 'cm3'),
(20, 'Metros', 'm'),
(21, 'Metros Cuadrados', 'm2'),
(22, 'Metros Cubicos', 'm3'),
(23, 'Kilometros', 'km'),
(24, 'Hectareas', 'hec'),
(25, 'Millas', 'mi'),
(26, 'Decenas', 'dec'),
(27, 'Centenas', 'cen'),
(28, 'Docenas', 'doc'),
(29, 'Cientos', 'ciento'),
(30, 'Millar', 'millar'),
(31, 'Millon', 'millon'),
(32, 'Pieza', 'pza'),
(33, 'KiloWatts', 'kw'),
(34, 'Caballos Fuerza', 'hp'),
(35, 'Otros', 'otro');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id_usuario` int(11) NOT NULL,
  `id_rol` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `username` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombres` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dni` varchar(8) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `domicilio` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `genero` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_avatar` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id_usuario`, `id_rol`, `id_local`, `username`, `password`, `nombres`, `apellidos`, `dni`, `fecha_nacimiento`, `domicilio`, `email`, `telefono`, `genero`, `url_avatar`, `estado`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 'admin', '$2y$10$3/KdHVziAnYyTU1a8rW7g.Iu6zybtnMNp6jZIIrWDAytU4A5C/aXa', 'ADMINISTRADOR', 'DEL SISTEMA', '00000000', NULL, 'NO ELIMINAR', 'carlosyasmany14@gmail.com', '983621793', '', 'img/avatar/default.png', 1, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas`
--

CREATE TABLE `ventas` (
  `id_venta` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `id_local` int(11) NOT NULL,
  `id_cliente` int(11) DEFAULT NULL,
  `id_nota` int(11) DEFAULT NULL,
  `id_tipo_comprobante` int(11) NOT NULL,
  `serie_comprobante` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_comprobante` int(11) NOT NULL,
  `nombre_comprobante` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_venta` date DEFAULT NULL,
  `tipo_pago` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_pago` date DEFAULT NULL,
  `total_venta` decimal(9,2) DEFAULT NULL,
  `igv_total` decimal(9,2) NOT NULL DEFAULT '0.00',
  `gravado_total` decimal(9,2) NOT NULL DEFAULT '0.00',
  `descuento_global` decimal(9,2) DEFAULT NULL,
  `observacion` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contingencia` tinyint(4) NOT NULL DEFAULT '0',
  `numero_cuotas` tinyint(4) NOT NULL DEFAULT '0',
  `estado_envio` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mensaje_envio` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `ventas`
--

INSERT INTO `ventas` (`id_venta`, `id_usuario`, `id_local`, `id_cliente`, `id_nota`, `id_tipo_comprobante`, `serie_comprobante`, `numero_comprobante`, `nombre_comprobante`, `fecha_venta`, `tipo_pago`, `fecha_pago`, `total_venta`, `igv_total`, `gravado_total`, `descuento_global`, `observacion`, `contingencia`, `numero_cuotas`, `estado_envio`, `mensaje_envio`, `estado`, `created_at`, `updated_at`) VALUES
(1, 1, 1, NULL, NULL, 1, 'FF01', 0, NULL, NULL, NULL, NULL, NULL, '0.00', '0.00', NULL, NULL, 0, 0, NULL, NULL, 1, NULL, NULL),
(2, 1, 1, NULL, NULL, 2, 'BB01', 0, NULL, NULL, NULL, NULL, NULL, '0.00', '0.00', NULL, NULL, 0, 0, NULL, NULL, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas_credito`
--

CREATE TABLE `ventas_credito` (
  `id_ventas_credito` int(11) NOT NULL,
  `id_venta` int(11) NOT NULL,
  `nombre_cuota` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_cuota` int(11) DEFAULT NULL,
  `monto_cuota` decimal(9,2) DEFAULT NULL,
  `fecha_pago_cuota` date DEFAULT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `bajas`
--
ALTER TABLE `bajas`
  ADD PRIMARY KEY (`id_baja`),
  ADD KEY `bajas_id_usuario_foreign` (`id_usuario`),
  ADD KEY `bajas_id_local_foreign` (`id_local`),
  ADD KEY `bajas_id_venta_foreign` (`id_venta`),
  ADD KEY `bajas_id_nota_foreign` (`id_nota`),
  ADD KEY `bajas_id_tipo_comprobante_foreign` (`id_tipo_comprobante`);

--
-- Indices de la tabla `clientes`
--
ALTER TABLE `clientes`
  ADD PRIMARY KEY (`id_cliente`),
  ADD KEY `clientes_id_tipo_documento_foreign` (`id_tipo_documento`);

--
-- Indices de la tabla `compras`
--
ALTER TABLE `compras`
  ADD PRIMARY KEY (`id_compra`),
  ADD KEY `compras_id_usuario_foreign` (`id_usuario`),
  ADD KEY `compras_id_proveedor_foreign` (`id_proveedor`),
  ADD KEY `compras_id_local_foreign` (`id_local`);

--
-- Indices de la tabla `delivery`
--
ALTER TABLE `delivery`
  ADD PRIMARY KEY (`id_delivery`),
  ADD KEY `delivery_id_local_foreign` (`id_local`),
  ADD KEY `delivery_id_usuario_foreign` (`id_usuario`);

--
-- Indices de la tabla `detalle_compra`
--
ALTER TABLE `detalle_compra`
  ADD PRIMARY KEY (`id_detalle_compra`),
  ADD KEY `detalle_compra_id_producto_foreign` (`id_producto`),
  ADD KEY `detalle_compra_id_compra_foreign` (`id_compra`);

--
-- Indices de la tabla `detalle_credito`
--
ALTER TABLE `detalle_credito`
  ADD PRIMARY KEY (`id_detalle_credito`),
  ADD KEY `detalle_credito_id_usuario_foreign` (`id_usuario`),
  ADD KEY `detalle_credito_id_venta_foreign` (`id_venta`);

--
-- Indices de la tabla `detalle_delivery`
--
ALTER TABLE `detalle_delivery`
  ADD PRIMARY KEY (`id_detalle_delivery`),
  ADD KEY `detalle_delivery_id_delivery_foreign` (`id_delivery`),
  ADD KEY `detalle_delivery_id_producto_foreign` (`id_producto`);

--
-- Indices de la tabla `detalle_guia_remision`
--
ALTER TABLE `detalle_guia_remision`
  ADD PRIMARY KEY (`id_detalle_guia_remision`),
  ADD KEY `detalle_guia_remision_id_guia_remision_foreign` (`id_guia_remision`),
  ADD KEY `detalle_guia_remision_id_producto_foreign` (`id_producto`);

--
-- Indices de la tabla `detalle_proforma`
--
ALTER TABLE `detalle_proforma`
  ADD PRIMARY KEY (`id_detalle_proforma`),
  ADD KEY `detalle_proforma_id_proforma_foreign` (`id_proforma`),
  ADD KEY `detalle_proforma_id_producto_foreign` (`id_producto`);

--
-- Indices de la tabla `detalle_resumen`
--
ALTER TABLE `detalle_resumen`
  ADD PRIMARY KEY (`id_detalle_resumen`),
  ADD KEY `detalle_resumen_id_resumen_foreign` (`id_resumen`),
  ADD KEY `detalle_resumen_id_venta_foreign` (`id_venta`),
  ADD KEY `detalle_resumen_id_nota_foreign` (`id_nota`);

--
-- Indices de la tabla `detalle_traslado`
--
ALTER TABLE `detalle_traslado`
  ADD PRIMARY KEY (`id_detalle_traslado`),
  ADD KEY `detalle_traslado_id_traslado_foreign` (`id_traslado`),
  ADD KEY `detalle_traslado_id_producto_foreign` (`id_producto`);

--
-- Indices de la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  ADD PRIMARY KEY (`id_detalle_venta`),
  ADD KEY `detalle_venta_id_venta_foreign` (`id_venta`),
  ADD KEY `detalle_venta_id_producto_foreign` (`id_producto`);

--
-- Indices de la tabla `egresos`
--
ALTER TABLE `egresos`
  ADD PRIMARY KEY (`id_egreso`),
  ADD KEY `egresos_id_local_foreign` (`id_local`),
  ADD KEY `egresos_id_usuario_foreign` (`id_usuario`);

--
-- Indices de la tabla `empresa`
--
ALTER TABLE `empresa`
  ADD PRIMARY KEY (`id_empresa`);

--
-- Indices de la tabla `guia_remision`
--
ALTER TABLE `guia_remision`
  ADD PRIMARY KEY (`id_guia_remision`),
  ADD KEY `guia_remision_id_local_foreign` (`id_local`),
  ADD KEY `guia_remision_id_usuario_foreign` (`id_usuario`),
  ADD KEY `guia_remision_id_venta_foreign` (`id_venta`),
  ADD KEY `guia_remision_id_cliente_foreign` (`id_cliente`),
  ADD KEY `guia_remision_id_tipo_comprobante_foreign` (`id_tipo_comprobante`);

--
-- Indices de la tabla `local`
--
ALTER TABLE `local`
  ADD PRIMARY KEY (`id_local`),
  ADD KEY `local_id_tipo_local_foreign` (`id_tipo_local`);

--
-- Indices de la tabla `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `notas`
--
ALTER TABLE `notas`
  ADD PRIMARY KEY (`id_nota`),
  ADD KEY `notas_id_venta_foreign` (`id_venta`),
  ADD KEY `notas_id_usuario_foreign` (`id_usuario`),
  ADD KEY `notas_id_local_foreign` (`id_local`),
  ADD KEY `notas_id_tipo_comprobante_foreign` (`id_tipo_comprobante`);

--
-- Indices de la tabla `productos`
--
ALTER TABLE `productos`
  ADD PRIMARY KEY (`id_producto`),
  ADD KEY `productos_id_tipo_presentacion_foreign` (`id_tipo_presentacion`),
  ADD KEY `productos_id_unidad_medida_foreign` (`id_unidad_medida`);

--
-- Indices de la tabla `producto_local`
--
ALTER TABLE `producto_local`
  ADD PRIMARY KEY (`id_producto_local`),
  ADD KEY `producto_local_id_producto_foreign` (`id_producto`),
  ADD KEY `producto_local_id_local_foreign` (`id_local`);

--
-- Indices de la tabla `proformas`
--
ALTER TABLE `proformas`
  ADD PRIMARY KEY (`id_proforma`),
  ADD KEY `proformas_id_local_foreign` (`id_local`),
  ADD KEY `proformas_id_usuario_foreign` (`id_usuario`);

--
-- Indices de la tabla `proveedores`
--
ALTER TABLE `proveedores`
  ADD PRIMARY KEY (`id_proveedor`),
  ADD KEY `proveedores_id_tipo_documento_foreign` (`id_tipo_documento`);

--
-- Indices de la tabla `resumenes`
--
ALTER TABLE `resumenes`
  ADD PRIMARY KEY (`id_resumen`),
  ADD KEY `resumenes_id_local_foreign` (`id_local`),
  ADD KEY `resumenes_id_tipo_comprobante_foreign` (`id_tipo_comprobante`);

--
-- Indices de la tabla `retiros`
--
ALTER TABLE `retiros`
  ADD PRIMARY KEY (`id_retiro`),
  ADD KEY `retiros_id_local_foreign` (`id_local`),
  ADD KEY `retiros_id_producto_foreign` (`id_producto`),
  ADD KEY `retiros_id_usuario_foreign` (`id_usuario`);

--
-- Indices de la tabla `rol`
--
ALTER TABLE `rol`
  ADD PRIMARY KEY (`id_rol`);

--
-- Indices de la tabla `tipo_comprobante`
--
ALTER TABLE `tipo_comprobante`
  ADD PRIMARY KEY (`id_tipo_comprobante`);

--
-- Indices de la tabla `tipo_documento`
--
ALTER TABLE `tipo_documento`
  ADD PRIMARY KEY (`id_tipo_documento`);

--
-- Indices de la tabla `tipo_local`
--
ALTER TABLE `tipo_local`
  ADD PRIMARY KEY (`id_tipo_local`);

--
-- Indices de la tabla `tipo_presentacion`
--
ALTER TABLE `tipo_presentacion`
  ADD PRIMARY KEY (`id_tipo_presentacion`);

--
-- Indices de la tabla `traslados`
--
ALTER TABLE `traslados`
  ADD PRIMARY KEY (`id_traslado`),
  ADD KEY `traslados_id_local_origen_foreign` (`id_local_origen`),
  ADD KEY `traslados_id_local_destino_foreign` (`id_local_destino`),
  ADD KEY `traslados_id_usuario_foreign` (`id_usuario`);

--
-- Indices de la tabla `unidad_medida`
--
ALTER TABLE `unidad_medida`
  ADD PRIMARY KEY (`id_unidad_medida`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id_usuario`),
  ADD KEY `usuarios_id_rol_foreign` (`id_rol`),
  ADD KEY `usuarios_id_local_foreign` (`id_local`);

--
-- Indices de la tabla `ventas`
--
ALTER TABLE `ventas`
  ADD PRIMARY KEY (`id_venta`),
  ADD KEY `ventas_id_local_foreign` (`id_local`),
  ADD KEY `ventas_id_usuario_foreign` (`id_usuario`),
  ADD KEY `ventas_id_cliente_foreign` (`id_cliente`),
  ADD KEY `ventas_id_tipo_comprobante_foreign` (`id_tipo_comprobante`);

--
-- Indices de la tabla `ventas_credito`
--
ALTER TABLE `ventas_credito`
  ADD PRIMARY KEY (`id_ventas_credito`),
  ADD KEY `ventas_credito_id_venta_foreign` (`id_venta`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `bajas`
--
ALTER TABLE `bajas`
  MODIFY `id_baja` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `clientes`
--
ALTER TABLE `clientes`
  MODIFY `id_cliente` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `compras`
--
ALTER TABLE `compras`
  MODIFY `id_compra` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `delivery`
--
ALTER TABLE `delivery`
  MODIFY `id_delivery` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_compra`
--
ALTER TABLE `detalle_compra`
  MODIFY `id_detalle_compra` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_credito`
--
ALTER TABLE `detalle_credito`
  MODIFY `id_detalle_credito` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_delivery`
--
ALTER TABLE `detalle_delivery`
  MODIFY `id_detalle_delivery` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_guia_remision`
--
ALTER TABLE `detalle_guia_remision`
  MODIFY `id_detalle_guia_remision` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_proforma`
--
ALTER TABLE `detalle_proforma`
  MODIFY `id_detalle_proforma` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_resumen`
--
ALTER TABLE `detalle_resumen`
  MODIFY `id_detalle_resumen` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_traslado`
--
ALTER TABLE `detalle_traslado`
  MODIFY `id_detalle_traslado` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  MODIFY `id_detalle_venta` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `egresos`
--
ALTER TABLE `egresos`
  MODIFY `id_egreso` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `empresa`
--
ALTER TABLE `empresa`
  MODIFY `id_empresa` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `guia_remision`
--
ALTER TABLE `guia_remision`
  MODIFY `id_guia_remision` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `local`
--
ALTER TABLE `local`
  MODIFY `id_local` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=34;

--
-- AUTO_INCREMENT de la tabla `notas`
--
ALTER TABLE `notas`
  MODIFY `id_nota` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `productos`
--
ALTER TABLE `productos`
  MODIFY `id_producto` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `producto_local`
--
ALTER TABLE `producto_local`
  MODIFY `id_producto_local` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `proformas`
--
ALTER TABLE `proformas`
  MODIFY `id_proforma` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `proveedores`
--
ALTER TABLE `proveedores`
  MODIFY `id_proveedor` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `resumenes`
--
ALTER TABLE `resumenes`
  MODIFY `id_resumen` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `retiros`
--
ALTER TABLE `retiros`
  MODIFY `id_retiro` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `rol`
--
ALTER TABLE `rol`
  MODIFY `id_rol` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `tipo_comprobante`
--
ALTER TABLE `tipo_comprobante`
  MODIFY `id_tipo_comprobante` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de la tabla `tipo_documento`
--
ALTER TABLE `tipo_documento`
  MODIFY `id_tipo_documento` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `tipo_local`
--
ALTER TABLE `tipo_local`
  MODIFY `id_tipo_local` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `tipo_presentacion`
--
ALTER TABLE `tipo_presentacion`
  MODIFY `id_tipo_presentacion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=43;

--
-- AUTO_INCREMENT de la tabla `traslados`
--
ALTER TABLE `traslados`
  MODIFY `id_traslado` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `unidad_medida`
--
ALTER TABLE `unidad_medida`
  MODIFY `id_unidad_medida` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=36;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id_usuario` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `ventas`
--
ALTER TABLE `ventas`
  MODIFY `id_venta` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `ventas_credito`
--
ALTER TABLE `ventas_credito`
  MODIFY `id_ventas_credito` int(11) NOT NULL AUTO_INCREMENT;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `bajas`
--
ALTER TABLE `bajas`
  ADD CONSTRAINT `bajas_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `bajas_id_nota_foreign` FOREIGN KEY (`id_nota`) REFERENCES `notas` (`id_nota`),
  ADD CONSTRAINT `bajas_id_tipo_comprobante_foreign` FOREIGN KEY (`id_tipo_comprobante`) REFERENCES `tipo_comprobante` (`id_tipo_comprobante`),
  ADD CONSTRAINT `bajas_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`),
  ADD CONSTRAINT `bajas_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`);

--
-- Filtros para la tabla `clientes`
--
ALTER TABLE `clientes`
  ADD CONSTRAINT `clientes_id_tipo_documento_foreign` FOREIGN KEY (`id_tipo_documento`) REFERENCES `tipo_documento` (`id_tipo_documento`);

--
-- Filtros para la tabla `compras`
--
ALTER TABLE `compras`
  ADD CONSTRAINT `compras_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `compras_id_proveedor_foreign` FOREIGN KEY (`id_proveedor`) REFERENCES `proveedores` (`id_proveedor`),
  ADD CONSTRAINT `compras_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `delivery`
--
ALTER TABLE `delivery`
  ADD CONSTRAINT `delivery_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `delivery_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `detalle_compra`
--
ALTER TABLE `detalle_compra`
  ADD CONSTRAINT `detalle_compra_id_compra_foreign` FOREIGN KEY (`id_compra`) REFERENCES `compras` (`id_compra`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `detalle_compra_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`);

--
-- Filtros para la tabla `detalle_credito`
--
ALTER TABLE `detalle_credito`
  ADD CONSTRAINT `detalle_credito_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`),
  ADD CONSTRAINT `detalle_credito_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`);

--
-- Filtros para la tabla `detalle_delivery`
--
ALTER TABLE `detalle_delivery`
  ADD CONSTRAINT `detalle_delivery_id_delivery_foreign` FOREIGN KEY (`id_delivery`) REFERENCES `delivery` (`id_delivery`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `detalle_delivery_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`);

--
-- Filtros para la tabla `detalle_guia_remision`
--
ALTER TABLE `detalle_guia_remision`
  ADD CONSTRAINT `detalle_guia_remision_id_guia_remision_foreign` FOREIGN KEY (`id_guia_remision`) REFERENCES `guia_remision` (`id_guia_remision`),
  ADD CONSTRAINT `detalle_guia_remision_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`);

--
-- Filtros para la tabla `detalle_proforma`
--
ALTER TABLE `detalle_proforma`
  ADD CONSTRAINT `detalle_proforma_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`),
  ADD CONSTRAINT `detalle_proforma_id_proforma_foreign` FOREIGN KEY (`id_proforma`) REFERENCES `proformas` (`id_proforma`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `detalle_resumen`
--
ALTER TABLE `detalle_resumen`
  ADD CONSTRAINT `detalle_resumen_id_nota_foreign` FOREIGN KEY (`id_nota`) REFERENCES `notas` (`id_nota`),
  ADD CONSTRAINT `detalle_resumen_id_resumen_foreign` FOREIGN KEY (`id_resumen`) REFERENCES `resumenes` (`id_resumen`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `detalle_resumen_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`);

--
-- Filtros para la tabla `detalle_traslado`
--
ALTER TABLE `detalle_traslado`
  ADD CONSTRAINT `detalle_traslado_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`),
  ADD CONSTRAINT `detalle_traslado_id_traslado_foreign` FOREIGN KEY (`id_traslado`) REFERENCES `traslados` (`id_traslado`);

--
-- Filtros para la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  ADD CONSTRAINT `detalle_venta_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`),
  ADD CONSTRAINT `detalle_venta_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `egresos`
--
ALTER TABLE `egresos`
  ADD CONSTRAINT `egresos_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `egresos_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `guia_remision`
--
ALTER TABLE `guia_remision`
  ADD CONSTRAINT `guia_remision_id_cliente_foreign` FOREIGN KEY (`id_cliente`) REFERENCES `clientes` (`id_cliente`),
  ADD CONSTRAINT `guia_remision_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `guia_remision_id_tipo_comprobante_foreign` FOREIGN KEY (`id_tipo_comprobante`) REFERENCES `tipo_comprobante` (`id_tipo_comprobante`),
  ADD CONSTRAINT `guia_remision_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`),
  ADD CONSTRAINT `guia_remision_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`);

--
-- Filtros para la tabla `local`
--
ALTER TABLE `local`
  ADD CONSTRAINT `local_id_tipo_local_foreign` FOREIGN KEY (`id_tipo_local`) REFERENCES `tipo_local` (`id_tipo_local`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `notas`
--
ALTER TABLE `notas`
  ADD CONSTRAINT `notas_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `notas_id_tipo_comprobante_foreign` FOREIGN KEY (`id_tipo_comprobante`) REFERENCES `tipo_comprobante` (`id_tipo_comprobante`),
  ADD CONSTRAINT `notas_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`),
  ADD CONSTRAINT `notas_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`);

--
-- Filtros para la tabla `productos`
--
ALTER TABLE `productos`
  ADD CONSTRAINT `productos_id_tipo_presentacion_foreign` FOREIGN KEY (`id_tipo_presentacion`) REFERENCES `tipo_presentacion` (`id_tipo_presentacion`),
  ADD CONSTRAINT `productos_id_unidad_medida_foreign` FOREIGN KEY (`id_unidad_medida`) REFERENCES `unidad_medida` (`id_unidad_medida`);

--
-- Filtros para la tabla `producto_local`
--
ALTER TABLE `producto_local`
  ADD CONSTRAINT `producto_local_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `producto_local_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `proformas`
--
ALTER TABLE `proformas`
  ADD CONSTRAINT `proformas_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `proformas_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `proveedores`
--
ALTER TABLE `proveedores`
  ADD CONSTRAINT `proveedores_id_tipo_documento_foreign` FOREIGN KEY (`id_tipo_documento`) REFERENCES `tipo_documento` (`id_tipo_documento`);

--
-- Filtros para la tabla `resumenes`
--
ALTER TABLE `resumenes`
  ADD CONSTRAINT `resumenes_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `resumenes_id_tipo_comprobante_foreign` FOREIGN KEY (`id_tipo_comprobante`) REFERENCES `tipo_comprobante` (`id_tipo_comprobante`);

--
-- Filtros para la tabla `retiros`
--
ALTER TABLE `retiros`
  ADD CONSTRAINT `retiros_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `retiros_id_producto_foreign` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id_producto`),
  ADD CONSTRAINT `retiros_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `traslados`
--
ALTER TABLE `traslados`
  ADD CONSTRAINT `traslados_id_local_destino_foreign` FOREIGN KEY (`id_local_destino`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `traslados_id_local_origen_foreign` FOREIGN KEY (`id_local_origen`) REFERENCES `local` (`id_local`),
  ADD CONSTRAINT `traslados_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD CONSTRAINT `usuarios_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `usuarios_id_rol_foreign` FOREIGN KEY (`id_rol`) REFERENCES `rol` (`id_rol`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `ventas`
--
ALTER TABLE `ventas`
  ADD CONSTRAINT `ventas_id_cliente_foreign` FOREIGN KEY (`id_cliente`) REFERENCES `clientes` (`id_cliente`),
  ADD CONSTRAINT `ventas_id_local_foreign` FOREIGN KEY (`id_local`) REFERENCES `local` (`id_local`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `ventas_id_tipo_comprobante_foreign` FOREIGN KEY (`id_tipo_comprobante`) REFERENCES `tipo_comprobante` (`id_tipo_comprobante`),
  ADD CONSTRAINT `ventas_id_usuario_foreign` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`);

--
-- Filtros para la tabla `ventas_credito`
--
ALTER TABLE `ventas_credito`
  ADD CONSTRAINT `ventas_credito_id_venta_foreign` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id_venta`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
