<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE PEDIDOS POR DELIVERY</h4>

           <div class="ui equal width grid">
                <div class="row">
                    <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="<?php echo e(url('delivery/buscar')); ?>" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="estado_envio">
                            <option value="">Seleccione</option>
                            <option value="TODOS">TODOS</option>
                            <option value="0">PENDIENTES</option>
                            <option value="1">ATENDIDOS</option>
                            <option value="2">CANCELADOS</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Delivery</th>
                        <th class="head_table">Cliente</th>
                        <th class="head_table">DNI / RUC</th>
                        <th class="head_table">Fecha Pedido</th>
                        <th class="head_table">Monto S/</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($delivery->id_delivery); ?>">
                        <td><?php echo e($i); ?></td>
                         <td>PEDIDO N° <?php echo e($delivery->id_delivery); ?></td>
                        <td><?php echo e($delivery->nombre); ?></td>
                        <td><?php echo e($delivery->numero_documento); ?></td>
                       
                        <td><?php echo e($delivery->fecha_emision); ?></td>
                        <td><?php echo e($delivery->total); ?></td>
                        <td>
                            <?php if($delivery->estado_delivery == "ATENDIDO"): ?>
                                <div class="ui green label"><?php echo e($delivery->estado_delivery); ?></div>
                            <?php elseif($delivery->estado_delivery == "PENDIENTE"): ?>
                                <div class="ui yellow label"><?php echo e($delivery->estado_delivery); ?></div>
                            <?php elseif($delivery->estado_delivery == "CANCELADO"): ?>
                                <div class="ui red label"><?php echo e($delivery->estado_delivery); ?></div>
                            <?php endif; ?>
                        </td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="<?php echo e(url('delivery/detalles/'.$delivery->id_delivery)); ?>">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="8">
                            <?php echo $__env->make('layout.includes.pagination', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/delivery/listar.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>