<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateComprasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('compras', function (Blueprint $table) {
            $table->integer('id_compra')->autoIncrement();
            $table->integer('id_usuario');
            $table->integer('id_local');
            $table->integer('id_proveedor')->nullable();
            $table->string('tipo_comprobante', 15)->nullable();
            $table->string('numero_comprobante', 20)->nullable();
            $table->date('fecha_compra')->nullable();
            $table->string('tipo_compra', 15)->nullable();
            $table->date('fecha_pago')->nullable();
            $table->decimal('total_compra', 9, 2);
            $table->string('observacion', 800)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios');
            $table->foreign('id_proveedor')->references('id_proveedor')->on('proveedores');

            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('producto_almacen');
    }
}
