<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVentasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ventas', function (Blueprint $table) {
            $table->integer('id_venta')->autoIncrement();
            $table->integer('id_usuario');
            $table->integer('id_local');
            $table->integer('id_cliente')->nullable();
            $table->integer('id_nota')->nullable();
            $table->integer('id_tipo_comprobante'); 
            $table->string('serie_comprobante', 5);
            $table->integer('numero_comprobante');
            $table->string('nombre_comprobante', 20)->nullable();
            $table->date('fecha_venta')->nullable();
            $table->string('tipo_pago', 15)->nullable(); //CREDITO, CONTADO, TARJETA
            $table->date('fecha_pago')->nullable(); //SOLO PARA TIPO PAGO CREDITO
            $table->decimal('total_venta', 9, 2)->nullable();
            $table->decimal('igv_total', 9, 2)->default('0');
            $table->decimal('gravado_total', 9, 2)->default('0');
            $table->decimal('descuento_global', 9, 2)->nullable();
            $table->string('observacion', 200)->nullable();
            $table->tinyInteger('contingencia')->default('0');
            $table->tinyInteger('numero_cuotas')->default('0');
            $table->string('estado_envio', 15)->nullable(); //REGISTRADO, ACEPTADO, NO ENVIADO, RECHAZADO
            $table->string('mensaje_envio', 500)->nullable();
            $table->tinyInteger('estado')->default('1'); // 1 = activo, 0 = anulado con nota
            $table->timestamps();

            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios');    
            $table->foreign('id_cliente')->references('id_cliente')->on('clientes');  
            $table->foreign('id_tipo_comprobante')->references('id_tipo_comprobante')->on('tipo_comprobante');       
                  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ventas');
    }
}
