@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REPORTE DE PRODUCTOS VENCIDOS</h4>
            <br>

            <form class="ui form" id="frmComprobante" autocomplete="off">

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Tienda o Sucursal</div>
                    </div>
                    <div class="eleven wide field">
                        <select class="ui fluid small input dropdown" name="id_local">
                            <option value="0">Todos las sucursales</option>
                            @foreach($locales as $local)
                               <option value="{{ $local->id_local }}"> {{ $local->nombre }} ({{ ucwords(mb_strtolower($local->direccion ))}})</option>
                            @endforeach
   
                        </select>  
                    </div>
                </div> 

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Tipo de Reporte</div>
                    </div>
                    <div class="five wide field">
                        <select class="ui fluid small input dropdown" name="opcion">
                            <option value="1">Productos que ya estan vencidos</option>
                            <option value="2">Productos que caducaran en 5 meses</option>
                        </select>  
                    </div>
                </div> 
                

                <div class="form_footer">
                    <div class="ui right floated primary button btn_reporte_productos_vencidos"><i class="download icon"></i>DESCARGAR REPORTE</div>
                </div>    
            </form>

            

        </div>
    </div>
    
@stop

@section('scripts')
    <script src="{{ asset('js/reporte/comprobantes.js') }}"></script>
@stop


