@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE TRASLADO DE PRODUCTOS</h4>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Local de Origen</th>
                        <th class="head_table">Local de Destino</th>
                        <th class="head_table">Motivo de Traslado</th>
                        <th class="head_table">Fecha de Traslado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $row)
                    <tr data-table="{{ $row->id_traslado }}">
                        <td>{{ $i }}</td>
                        <td>{{ $row->local_origen->nombre }}</td>
                        <td>{{ $row->local_destino->nombre }}</td>
                        <td>{{ $row->descripcion }}</td>
                        <td>{{ $row->created_at}}</td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('traslado/detalles/'.$row->id_traslado) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="6">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop


