<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GuiaRemision extends Model
{
    protected $table = 'guia_remision';
    protected $primaryKey = 'id_guia_remision';

    protected $fillable = [
        'id_guia_remision', 'id_usuario', 'id_local', 'id_cliente', 'id_venta', 'id_tipo_comprobante', 'serie_guia', 'numero_guia', 'nombre_guia','fecha_emision', 'fecha_traslado','motivo', 'punto_partida', 'punto_llegada', 'nombre_transportista',  'documento_transportista', 'licencia', 'marca_placa','peso','observacion', 'estado_envio', 'mensaje_envio', 'estado'
    ];

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }

    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }

    public function tipo_comprobante()
    {
        return $this->belongsTo('App\Models\TipoComprobante', 'id_tipo_comprobante');
    }

    public function cliente()
    {
        return $this->belongsTo('App\Models\Cliente', 'id_cliente');
    }


}
