<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">EMITIR NUEVA PROFORMA</h4>
            
            <form class="ui form" id="frmNuevo" autocomplete="off"> 
            
                <br>

                <div class="four fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="tipo_doc">RUC / DNI</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input" >
                              <input type="text"  name="numero_documento" maxlength="11">
                        </div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Nombre del cliente</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text"  name="nombre" maxlength="200" oninput="$.upperCase(this)">
                        </div>  
                    </div>
                </div>

                <div class="three fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Direccion del cliente</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text" name="direccion"  maxlength="200" oninput="$.upperCase(this)">
                        </div>  
                    </div>
                </div>

                

                <div class="five fields" style="visibility: hidden;">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Fecha de Emision</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha hasDate" name="fecha_emision" >
                        </div> 
                    </div>
                </div>
               
                
                <div class="four fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Buscar producto</div>
                    </div>
                    <div class="eight wide field">
                        <select class="ui small search selection dropdown" name="id_prod">
                            <option value="">Buscar...</option>
                            <?php $__currentLoopData = $productos->sortBy('producto.nombre'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <option value="<?php echo e($data->id_producto); ?>"><?php echo e($data->producto->nombre); ?> <?php echo e($data->producto->descripcion); ?> (<?php echo e($data->producto->tipo_presentacion->nombre); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select> 
                    </div>
                    
                    <div class="three wide field">
                        <div class="ui icon small input" id="loading_input">
                            <input type="text" id="codigo_barras" maxlength="100" placeholder="CODIGO DE BARRAS" onkeyup="$.buscarCodigoBarras()">
                            <i class="search icon"></i>
                        </div> 
                    </div> 
                    <div class="two wide field">
                        <div class="ui fluid small green button btn_buscar_producto" title="Clic para ver lista de productos"><i class="search icon"></i>VER TODO</div>
                    </div>
                    
                    
                </div>

                <br>
                    
                <table class="ui celled table">
                    <thead>
                        <tr>
                            <th class="center aligned">Producto</th>
                            <th class="center aligned" data-tooltip="Cantidad a vender" data-position="top center" data-inverted="">Cantidad</th>
                            <th class="center aligned" data-tooltip="Precio de venta unitario" data-position="top center" data-inverted="">Precio S/</th>
                            <th class="center aligned" data-tooltip="Monto para descuento" data-position="top center" data-inverted="">Dscto S/</th>
                            <th class="center aligned">Subtotal S/</th>
                            <th class="center aligned">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                </table>

                <div class="form_footer">
                    <div class="ui labeled small input">
                        <label class="ui brown label">TOTAL  S/</label>
                        <input type="text" name="total_venta" id="total_venta" size="5" readonly style="width: 0%">
                    </div> 
                    &nbsp;&nbsp;
                    <a href="#" class="btn_nuevo_producto">(+) Registrar nuevo</a>
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>EMITIR PROFORMA</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="circular inverted white dollar sign icon"></i>Emitir Proforma</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea emitir la proforma de estos productos?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar proforma"> <i class="paper plane icon"></i>Emitir</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start nuevo producto modal -->
    <div class="ui modal" id="nuevo_producto_modal">
        <div class="header">Registrar Nuevo Producto</div>     
        <div class="content">
            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNuevoProducto" autocomplete="off">
                
                <input type="hidden" name="id_unidad_medida" value="1">
                <input type="hidden" name="id_tipo_presentacion" value="1">
                <input type="hidden" name="situacion_impuesto" value="AFECTO">
                <input type="hidden" name="tipo_impuesto" value="IGV">
                <input type="hidden" name="valor_impuesto" value="18">
                <input type="hidden" name="tipo_producto" value="Generico">
               
                <div class="two fields">
                    <div class="twelve wide field">
                        <label>Nombre del Producto</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="200" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="four wide field">
                        <label>Precio de Venta</label>
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="precio" maxlength="11">
                        </div>  
                    </div>
                </div>  
                <div class="three fields">
                    <div class="eight wide field">
                        <label>Marca del producto</label>
                        <div class="ui small input ">
                          <input type="text" name="descripcion" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="four wide field">
                        <label>Presentacion</label>
                        <select class="ui small search selection dropdown" name="id_tipo_presentacion">
                            <?php $__currentLoopData = $tipo_presentacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->id_tipo_presentacion); ?>"><?php echo e($tipo->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                    <div class="four wide field">
                        <label>Codigo de Barras</label>
                        <div class="ui small input ">
                          <input type="text" name="codigo_barras" maxlength="100" oninput="$.upperCase(this)">
                        </div> 
                    </div>
                </div> 

            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_producto"><i class="plus icon"></i>AGREGAR</div>
        </div>
    </div>
    <!--end nuevo producto  modal --> 

    <!--start buscar producto modal -->

    <div class="ui standard large modal" id="buscar_producto_modal">
        <div class="header">Buscar Productos</div>
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_busqueda">
                <div class="ui text loader">Procesando...</div>
            </div>
            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_producto" name="buscar_producto" placeholder="Producto a buscar...">
                <div class="ui icon button" id="btn_buscar_prod" title="Clic para buscar"><i class="search icon"></i></div>
            </div> 


            <table class="ui celled striped table" id="tabla_productos">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Cod Barras</th>
                        <th class="head_table">Producto</th>
                        <th class="head_table">Presentacion</th>
                        <th class="head_table">U. Med</th>
                        <th class="head_table">Precio S/</th>
                        <th class="head_table">Vencimiento</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos">
                   <?php /**/ $i = 1/**/ ?>
                    <?php $__currentLoopData = $producto->sortBy('producto.nombre'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($row->id_producto); ?>">
                        <td><?php echo e($i); ?></td>
                        <td><?php echo e($row->producto->codigo_barras); ?></td>
                        <td><?php echo e($row->producto->nombre); ?> <?php echo e($row->producto->descripcion); ?></td>
                        <td><?php echo e($row->producto->tipo_presentacion->nombre); ?></td>
                        <td><?php echo e($row->producto->unidad_medida->nombre); ?></td>
                        <td><?php echo e($row->producto->precio); ?></td>
                        <td><?php echo e(!is_null($row->producto->fecha_vencimiento) ? $row->producto->fecha_vencimiento : "Sin fecha"); ?></td>
                        
                        <td>                            
                            <div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="<?php echo e($row->id_producto); ?>" data-stock="<?php echo e($row->stock); ?>" data-precio="<?php echo e($row->producto->precio); ?>">
                                <div class="hidden content">Elegir</div>
                                <div class="visible content"><i class="check icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>


            
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/proforma/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>