<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleGuiaRemision extends Model
{
    protected $table = 'detalle_guia_remision';
    protected $primaryKey = 'id_detalle_guia_remision';

    protected $fillable = [
        'id_detalle_guia_remision','id_guia_remision', 'id_producto', 'cantidad', 'estado'
    ];

    public function guia_remision()
    {
        return $this->belongsTo('App\Models\GuiaRemision', 'id_guia_remision');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
