<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Retiro extends Model
{
    protected $table = 'retiros';
    protected $primaryKey = 'id_retiro';

    protected $fillable = [
        'id_retiro', 'id_local', 'id_producto','id_usuario', 'motivo_retiro', 'cantidad_retiro', 'monto_perdido', 'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
