<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLocalTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('local', function (Blueprint $table) {
            $table->integer('id_local')->autoIncrement();
            $table->integer('id_tipo_local');
            $table->string('nombre', 100);
            $table->string('direccion', 200)->nullable();
            $table->string('telefono', 30)->nullable();
            $table->string('serie_factura', 5)->nullable();
            $table->string('serie_boleta', 5)->nullable();
            $table->string('serie_guia', 5)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_tipo_local')
                  ->references('id_tipo_local')->on('tipo_local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('local');
    }
}
