<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE TRASLADO DE PRODUCTOS</h4>
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registro el traslado :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->usuario->nombres))); ?> <?php echo e(ucwords(mb_strtolower($data->usuario->apellidos))); ?> (<?php echo e($data->usuario->username); ?>)</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registro el traslado :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->created_at))); ?></div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Motivo de Traslado :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><?php echo e($data->descripcion); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Flete del traslado :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">S/ <?php echo e($data->flete); ?></div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Local de Origen :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><?php echo e($data->local_origen->nombre); ?> (<?php echo e($data->local_origen->direccion); ?>)</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Local de Destino :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><?php echo e($data->local_destino->nombre); ?> (<?php echo e($data->local_destino->direccion); ?>)</div>
                    </div>
                </div>
            </div>


            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned">Marca</th>
                        <th class="center aligned">Codigo Barras</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">Presentacion</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio Venta S/</th>
                        <th class="center aligned">Cantidad Trasladada</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php $__currentLoopData = $detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($detalle->id_detalle_traslado); ?>">
                        <td><a href="<?php echo e(url('producto/editar/'.$detalle->id_producto)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($detalle->producto->nombre))); ?></a></td>
                        <td><?php echo e($detalle->producto->descripcion); ?></td>
                        <td><?php echo e($detalle->producto->codigo_barras != null ? $detalle->producto->codigo_barras : 'Sin codigo'); ?></td>
                        <td><?php echo e($detalle->producto->tipo_presentacion->nombre); ?></td>
                        <td><?php echo e($detalle->producto->precio); ?></td>

                        <td class="warning"><?php echo e($detalle->cantidad); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
            </div>  

        </div>
    </div>

 
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>